<?php
/***************************************************************************
 *                                sessions.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: sessions.php,v 1.7 2004/10/26 13:16:08 carls Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

//
// Adds/updates a new session to the database for the given userid.
// Returns the new session ID on success.
//
function session_begin($user_id, $user_ip, $page_id, $auto_create = 0, $enable_autologin = 0)
{
	global $db, $board_config, $pnconfig;
	global $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SID;

	$cookiename = $board_config['cookie_name'];
	$cookiepath = $board_config['cookie_path'];
	$cookiedomain = $board_config['cookie_domain'];
	$cookiesecure = $board_config['cookie_secure'];

	if ( isset($HTTP_COOKIE_VARS[$cookiename . '_sid']) || isset($HTTP_COOKIE_VARS[$cookiename . '_data']) )
	{
		$session_id = isset($HTTP_COOKIE_VARS[$cookiename . '_sid']) ? $HTTP_COOKIE_VARS[$cookiename . '_sid'] : '';
		$sessiondata = isset($HTTP_COOKIE_VARS[$cookiename . '_data']) ? unserialize(stripslashes($HTTP_COOKIE_VARS[$cookiename . '_data'])) : array();
		$sessionmethod = SESSION_METHOD_COOKIE;
	}
	else
	{
		$sessiondata = array();
		$session_id = ( isset($HTTP_GET_VARS['sid']) ) ? $HTTP_GET_VARS['sid'] : '';
		$sessionmethod = SESSION_METHOD_GET;
	}

	//
	if (!preg_match('/^[A-Za-z0-9]*$/', $session_id)) 
	{
		$session_id = '';
	}

	$last_visit = 0;
	$current_time = time();
	$expiry_time = $current_time - $board_config['session_length'];

// Begin PNphpBB2 Module
	if (pnUserLoggedIn()) 
	{
	 	$user_id=pnUserGetVar('uid');
		$login=1;

		// Does the user have admin rights?
		$admin_rights = pnSecAuthAction(0, 'PNphpBB2::', '::', ACCESS_ADMIN) ? 1 : 0;
	
		$sql = "SELECT * FROM " . USERS_TABLE . " WHERE user_id = $user_id";
		$result = $db->sql_query($sql);
		
		if (!($row = $db->sql_fetchrow($result)))
		{
		 	// User was not found in the phpBB2 database, we need to insert it.
			// If the Postnuke user site url is populated add it to their record.
			$user_site_url = (pnUserGetVar('url')) ? "http://" . preg_replace ("'http://'i", '',  pnUserGetVar('url')) : '';
			// If the user has a Postnuke avatar selected copy the avatar name over so it can be used.
			$user_avatar = (pnUserGetVar('pn_user_avatar') != "blank.gif") ? "'" . pnVarPrepForStore(pnUserGetVar('pn_user_avatar')) . "', 3, " : "'' , 0, ";

			// Obtain PN user password
			$sql = "SELECT pn_pass FROM " . $pnconfig[prefix] . "_users WHERE pn_uid='" . $user_id . "'";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(CRITICAL_ERROR, 'Could not obtain PN user table', '', __LINE__, __FILE__, $sql);
			}
      list($pn_user_pass) = $db->sql_fetchrow($result);

			// Insert the user record
			$sql= "INSERT INTO " . USERS_TABLE . " (user_id, username, user_regdate, user_password,	user_email,	user_icq,	user_website,	user_occ,	user_from, user_interests, user_sig, user_sig_bbcode_uid,	user_avatar, user_avatar_type, user_viewemail, user_aim, user_yim, user_msnm, user_attachsig, user_allowsmile, user_allowhtml, user_allowbbcode, user_allow_viewonline, user_notify, user_notify_pm, user_popup_pm, user_timezone, user_dateformat, user_lang, user_style, user_level, user_allow_pm, user_active, user_actkey) VALUES ($user_id, '" . pnVarPrepForStore(pnUserGetVar('uname')) . "', " . time() . ", '" . $pn_user_pass . "', '" . pnVarPrepForStore(pnUserGetVar('email')) . "', '" . pnVarPrepForStore(pnUserGetVar('user_icq')) . "', '" . pnVarPrepForStore($user_site_url) . "', '" . pnVarPrepForStore(pnUserGetVar('user_occ')) . "', '" . pnVarPrepForStore(pnUserGetVar('user_from')) . "', '" . pnVarPrepForStore(pnUserGetVar('user_intrest')) . "', '', '', " . $user_avatar . "0, '" . pnVarPrepForStore(pnUserGetVar('user_aim')) . "', '" . pnVarPrepForStore(pnUserGetVar('user_yim')) . "', '" . pnVarPrepForStore(pnUserGetVar('user_msnm')) . "', " . $board_config['allow_sig'] . ", " . $board_config['allow_smilies'] . ", " . $board_config['allow_html'] . ", " . $board_config['allow_bbcode'] . ", 1, 0, 1, 1, " . (pnUserGetVar('timezone_offset') - 12) . ", '" . $board_config['default_dateformat'] . "', '" . $board_config['default_lang'] . "', " . $board_config['default_style'] . ", $admin_rights, 1, 1, '')";

			if ( !($result = $db->sql_query($sql, BEGIN_TRANSACTION)) )
			{
				message_die(CRITICAL_ERROR, 'Could not insert data into users table', '', __LINE__, __FILE__, $sql);
			}
			
			// Insert new group data for this user
			$sql = "INSERT INTO " . GROUPS_TABLE . " (group_name, group_description, group_single_user, group_moderator)
				VALUES ('', 'Personal User', 1, 0)";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(CRITICAL_ERROR, 'Could not insert data into groups table', '', __LINE__, __FILE__, $sql);
			}
			
			$group_id = $db->sql_nextid();
	    
			$sql = "INSERT INTO " . USER_GROUP_TABLE . " (user_id, group_id, user_pending)
				VALUES ($user_id, $group_id, 0)";
			if( !($result = $db->sql_query($sql, END_TRANSACTION)) )
			{
				message_die(CRITICAL_ERROR, 'Could not insert data into user_group table', '', __LINE__, __FILE__, $sql);
			}
		}
		else
		{
		 	// Update user rights
			$admin_rights = $admin_rights == 0 && $row['user_level'] <> 0 ? $admin_rights = $row['user_level'] : $admin_rights;
		 	// User found lets update the user information
			$user_site_url = (pnUserGetVar('url')) ? "http://" . preg_replace ("'http://'i", '',  pnUserGetVar('url')) : '';
//			$user_avatar = (pnUserGetVar('pn_user_avatar') != "blank.gif") ? "user_avatar = '" . pnVarPrepForStore(pnUserGetVar('pn_user_avatar')) . "', user_avatar_type = 3, " : '';
			$user_avatar = '';

			// Obtain PN user password
			$sql = "SELECT pn_pass FROM " . $pnconfig[prefix] . "_users WHERE pn_uid='" . $user_id . "'";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(CRITICAL_ERROR, 'Could not obtain PN user table', '', __LINE__, __FILE__, $sql);
			}
      list($pn_user_pass) = $db->sql_fetchrow($result);

			// Update the user record
 		  $sql = "UPDATE " . USERS_TABLE . " SET " . $user_avatar . "username = '" . pnVarPrepForStore(pnUserGetVar('uname')) . "' ,user_password = '" . $pn_user_pass . "', user_email =  '" . pnVarPrepForStore(pnUserGetVar('email')) . "', user_icq = '" . pnVarPrepForStore(pnUserGetVar('user_icq')) . "', user_website = '" . pnVarPrepForStore($user_site_url) . "', user_occ = '" . pnVarPrepForStore(pnUserGetVar('user_occ')) . "', user_from = '" . pnVarPrepForStore(pnUserGetVar('user_from')) . "', user_interests = '" . pnVarPrepForStore(pnUserGetVar('user_intrest')) . "', user_aim = '" . pnVarPrepForStore(pnUserGetVar('user_aim')) . "', user_yim = '" . pnVarPrepForStore(pnUserGetVar('user_yim')) . "', user_msnm = '" . pnVarPrepForStore(pnUserGetVar('user_msnm')) . "', user_timezone = " . (pnUserGetVar('timezone_offset') - 12) . ", user_level = " . $admin_rights . " WHERE user_id = $user_id";

			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(CRITICAL_ERROR, 'Could not update users table', '', __LINE__, __FILE__, $sql);
			}
			
			// Update the group tables
			if ( stripslashes($row['username']) != pnUserGetVar('uname') )
			{
			 	 $sql = "UPDATE " . GROUPS_TABLE . "	SET group_name = '" . pnVarPrepForStore(pnUserGetVar('uname')) . "' WHERE group_name = '" . $row['username'] . "'";
				 if ( !$result = $db->sql_query($sql) )
				 {
			 	 		message_die(CRITICAL_ERROR, 'Could not rename users group', '', __LINE__, __FILE__, $sql);
				 }
			}
		}
	}  
	else
	{
		$user_id=ANONYMOUS;
		$enable_autologin = 0;
		$login=0;
	}
// End PNphpBB2 Module

	//
	// Try and pull the last time stored in a cookie, if it exists
	//
	$sql = "SELECT * 
		FROM " . USERS_TABLE . " 
		WHERE user_id = $user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not obtain lastvisit data from user table', '', __LINE__, __FILE__, $sql);
	}

	$userdata = $db->sql_fetchrow($result);

	if ( $user_id != ANONYMOUS )
	{
// Begin PNphpBB2 Module
//		$auto_login_key = $userdata['user_password'];

		if ( $auto_create )
		{
//			if ( isset($sessiondata['autologinid']) && $userdata['user_active'] )
			if ( $userdata['user_active'] )
			{
				// We have to login automagically
//				if( $sessiondata['autologinid'] == $auto_login_key )
//				{
					// autologinid matches password
					$login = 1;
					$enable_autologin = 1;
//				}
//				else
//				{
//					// No match; don't login, set as anonymous user
//					$login = 0; 
//					$enable_autologin = 0; 
//					$user_id = $userdata['user_id'] = ANONYMOUS;
//				}
// End PNphpBB2 Module
			}
			else
			{
				// Autologin is not set. Don't login, set as anonymous user
				$login = 0;
				$enable_autologin = 0;
				$user_id = $userdata['user_id'] = ANONYMOUS;
			}
		}
		else
		{
			$login = 1;
		}
	}
	else
	{
		$login = 0;
		$enable_autologin = 0;
	}

	//
	// Initial ban check against user id, IP and email address
	//
	preg_match('/(..)(..)(..)(..)/', $user_ip, $user_ip_parts);

	$sql = "SELECT ban_ip, ban_userid, ban_email, ban_email, ban_expire_time, ban_priv_reason, ban_pub_reason_mode, ban_pub_reason 
		FROM " . BANLIST_TABLE . " 
		WHERE ban_ip IN ('" . $user_ip_parts[1] . $user_ip_parts[2] . $user_ip_parts[3] . $user_ip_parts[4] . "', '" . $user_ip_parts[1] . $user_ip_parts[2] . $user_ip_parts[3] . "ff', '" . $user_ip_parts[1] . $user_ip_parts[2] . "ffff', '" . $user_ip_parts[1] . "ffffff')
			OR ban_userid = $user_id";
	if ( $user_id != ANONYMOUS )
	{
		$sql .= " OR ban_email LIKE '" . str_replace("\'", "''", $userdata['user_email']) . "' 
			OR ban_email LIKE '" . substr(str_replace("\'", "''", $userdata['user_email']), strpos(str_replace("\'", "''", $userdata['user_email']), "@")) . "'";
	}
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Could not obtain ban information', '', __LINE__, __FILE__, $sql);
	}

	if ( $ban_info = $db->sql_fetchrow($result) )
	{
		if ( $ban_info['ban_ip'] || $ban_info['ban_userid'] || $ban_info['ban_email'] && ((isset ($ban_info['ban_expire_time']) && $ban_info['ban_expire_time'] >= time ()) || !isset ($ban_info['ban_expire_time'])) )
		{
						if ($ban_info['ban_pub_reason_mode'] == '0' || !isset ($ban_info['ban_pub_reason_mode'])) {
				$reason = 'You_been_banned';
			} else if ($ban_info['ban_pub_reason_mode'] == '1') {
				$reason = str_replace ("\n", '<br />', stripslashes ($ban_info['ban_priv_reason']));
			} else if ($ban_info['ban_pub_reason_mode'] == '2') {
				$reason = str_replace ("\n", '<br />', stripslashes ($ban_info['ban_pub_reason']));
			}
				
			message_die(CRITICAL_MESSAGE, $reason);
		}
	}

	//
	// Create or update the session
	//
	$sql = "UPDATE " . SESSIONS_TABLE . "
		SET session_user_id = $user_id, session_start = $current_time, session_time = $current_time, session_page = $page_id, session_logged_in = $login
		WHERE session_id = '" . $session_id . "' 
			AND session_ip = '$user_ip'";
	if ( !$db->sql_query($sql) || !$db->sql_affectedrows() )
	{
		$session_id = md5(uniqid($user_ip));

		$sql = "INSERT INTO " . SESSIONS_TABLE . "
			(session_id, session_user_id, session_start, session_time, session_ip, session_page, session_logged_in)
			VALUES ('$session_id', $user_id, $current_time, $current_time, '$user_ip', $page_id, $login)";
		if ( !$db->sql_query($sql) )
		{
			message_die(CRITICAL_ERROR, 'Error creating new session', '', __LINE__, __FILE__, $sql);
		}
	}

	if ( $user_id != ANONYMOUS )
	{// ( $userdata['user_session_time'] > $expiry_time && $auto_create ) ? $userdata['user_lastvisit'] : ( 
		$last_visit = ( $userdata['user_session_time'] > 0 ) ? $userdata['user_session_time'] : $current_time; 

		$sql = "UPDATE " . USERS_TABLE . " 
			SET user_session_time = $current_time, user_session_page = $page_id, user_lastvisit = $last_visit
			WHERE user_id = $user_id";
		if ( !$db->sql_query($sql) )
		{
			message_die(CRITICAL_ERROR, 'Error updating last visit time', '', __LINE__, __FILE__, $sql);
		}

		$userdata['user_lastvisit'] = $last_visit;

		$sessiondata['autologinid'] = ( $enable_autologin && $sessionmethod == SESSION_METHOD_COOKIE ) ? $auto_login_key : '';
		$sessiondata['userid'] = $user_id;
	}

	$userdata['session_id'] = $session_id;
	$userdata['session_ip'] = $user_ip;
	$userdata['session_user_id'] = $user_id;
	$userdata['session_logged_in'] = $login;
	$userdata['session_page'] = $page_id;
	$userdata['session_start'] = $current_time;
	$userdata['session_time'] = $current_time;

	setcookie($cookiename . '_data', serialize($sessiondata), $current_time + 31536000, $cookiepath, $cookiedomain, $cookiesecure);
	setcookie($cookiename . '_sid', $session_id, 0, $cookiepath, $cookiedomain, $cookiesecure);

	$SID = 'sid=' . $session_id;

	return $userdata;
}

//
// Checks for a given user session, tidies session table and updates user
// sessions at each page refresh
//
function session_pagestart($user_ip, $thispage_id)
{
	global $db, $lang, $board_config;
	global $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SID;

	$cookiename = $board_config['cookie_name'];
	$cookiepath = $board_config['cookie_path'];
	$cookiedomain = $board_config['cookie_domain'];
	$cookiesecure = $board_config['cookie_secure'];

	$current_time = time();
	unset($userdata);

	if ( isset($HTTP_COOKIE_VARS[$cookiename . '_sid']) || isset($HTTP_COOKIE_VARS[$cookiename . '_data']) )
	{
		$sessiondata = isset( $HTTP_COOKIE_VARS[$cookiename . '_data'] ) ? unserialize(stripslashes($HTTP_COOKIE_VARS[$cookiename . '_data'])) : array();
		$session_id = isset( $HTTP_COOKIE_VARS[$cookiename . '_sid'] ) ? $HTTP_COOKIE_VARS[$cookiename . '_sid'] : '';
		$sessionmethod = SESSION_METHOD_COOKIE;
	}
	else
	{
		$sessiondata = array();
		$session_id = ( isset($HTTP_GET_VARS['sid']) ) ? $HTTP_GET_VARS['sid'] : '';
		$sessionmethod = SESSION_METHOD_GET;
	}

	//
  if (!preg_match('/^[A-Za-z0-9]*$/', $session_id))  
    {
		$session_id = '';
	}

	//
	// Does a session exist?
	//
	if ( !empty($session_id) )
	{
		//
		// session_id exists so go ahead and attempt to grab all
		// data in preparation
		//
		$sql = "SELECT u.*, s.*
			FROM " . SESSIONS_TABLE . " s, " . USERS_TABLE . " u
			WHERE s.session_id = '$session_id'
				AND u.user_id = s.session_user_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(CRITICAL_ERROR, 'Error doing DB query userdata row fetch', '', __LINE__, __FILE__, $sql);
		}

		$userdata = $db->sql_fetchrow($result);

		//
		// Did the session exist in the DB?
		//
		if ( isset($userdata['user_id']) )
		{
// Begin PNphpBB2 Module
		 	// OK we found a session, now determine if it should be logged in or not
			if (!pnUserLoggedIn() && $userdata['user_id'] <> ANONYMOUS )
			{
			 	 // PN user not logged in so this session should not be logged in.
				 session_end($userdata['session_id'], $userdata['user_id']);
				 unset($sessiondata['userid']);
				 if ( !($userdata = session_begin(ANONYMOUS, $user_ip, $thispage_id, FALSE)) )
				 {
				 		message_die(CRITICAL_ERROR, 'Error creating user session', '', __LINE__, __FILE__, $sql);
				 }
				 init_userprefs($userdata);
				 Return $userdata;
			}
			
			if (pnUserLoggedIn() && $userdata['user_id'] <> pnUserGetVar('uid') )
			{
			 	 // PN user not logged in so this session should not be logged in.
				 session_end($userdata['session_id'], $userdata['user_id']);
				 if ( !($userdata = session_begin(pnUserGetVar('uid'), $user_ip, $thispage_id, FALSE)) )
				 {
				 		message_die(CRITICAL_ERROR, 'Error creating user session', '', __LINE__, __FILE__, $sql);
				 }
			}
// End PNphpBB2 Module

			//
			// Do not check IP assuming equivalence, if IPv4 we'll check only first 24
			// bits ... I've been told (by vHiker) this should alleviate problems with 
			// load balanced et al proxies while retaining some reliance on IP security.
			//
			$ip_check_s = substr($userdata['session_ip'], 0, 6);
			$ip_check_u = substr($user_ip, 0, 6);

			if ($ip_check_s == $ip_check_u)
			{
				$SID = ($sessionmethod == SESSION_METHOD_GET || defined('IN_ADMIN')) ? 'sid=' . $session_id : '';

				//
				// Only update session DB a minute or so after last update
				//
				if ( $current_time - $userdata['session_time'] > 60 )
				{
					$sql = "UPDATE " . SESSIONS_TABLE . " 
						SET session_time = $current_time, session_page = $thispage_id 
						WHERE session_id = '" . $userdata['session_id'] . "'";
					if ( !$db->sql_query($sql) )
					{
						message_die(CRITICAL_ERROR, 'Error updating sessions table', '', __LINE__, __FILE__, $sql);
					}

					if ( $userdata['user_id'] != ANONYMOUS )
					{
						$sql = "UPDATE " . USERS_TABLE . " 
							SET user_session_time = $current_time, user_session_page = $thispage_id 
							WHERE user_id = " . $userdata['user_id'];
						if ( !$db->sql_query($sql) )
						{
							message_die(CRITICAL_ERROR, 'Error updating sessions table', '', __LINE__, __FILE__, $sql);
						}
					}

					//
					// Delete expired sessions
					//
					$expiry_time = $current_time - $board_config['session_length'];
					$sql = "DELETE FROM " . SESSIONS_TABLE . " 
						WHERE session_time < $expiry_time 
							AND session_id <> '$session_id'";
					if ( !$db->sql_query($sql) )
					{
						message_die(CRITICAL_ERROR, 'Error clearing sessions table', '', __LINE__, __FILE__, $sql);
					}

					setcookie($cookiename . '_data', serialize($sessiondata), $current_time + 31536000, $cookiepath, $cookiedomain, $cookiesecure);
					setcookie($cookiename . '_sid', $session_id, 0, $cookiepath, $cookiedomain, $cookiesecure);
				}
				
				return $userdata;
			}
		}
	}

	//
	// If we reach here then no (valid) session exists. So we'll create a new one,
	// using the cookie user_id if available to pull basic user prefs.
	//
	$user_id = ( isset($sessiondata['userid']) ) ? intval($sessiondata['userid']) : ANONYMOUS;

	if ( !($userdata = session_begin($user_id, $user_ip, $thispage_id, TRUE)) )
	{
		message_die(CRITICAL_ERROR, 'Error creating user session', '', __LINE__, __FILE__, $sql);
	}

	return $userdata;

}

//
// session_end closes out a session
// deleting the corresponding entry
// in the sessions table
//
function session_end($session_id, $user_id)
{
	global $db, $lang, $board_config;
	global $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SID;

	$cookiename = $board_config['cookie_name'];
	$cookiepath = $board_config['cookie_path'];
	$cookiedomain = $board_config['cookie_domain'];
	$cookiesecure = $board_config['cookie_secure'];

	$current_time = time();

	//
	// Pull cookiedata or grab the URI propagated sid
	//
	if ( isset($HTTP_COOKIE_VARS[$cookiename . '_sid']) )
	{
		$session_id = isset( $HTTP_COOKIE_VARS[$cookiename . '_sid'] ) ? $HTTP_COOKIE_VARS[$cookiename . '_sid'] : '';
		$sessionmethod = SESSION_METHOD_COOKIE;
	}
	else
	{
		$session_id = ( isset($HTTP_GET_VARS['sid']) ) ? $HTTP_GET_VARS['sid'] : '';
		$sessionmethod = SESSION_METHOD_GET;
	}

	if (!preg_match('/^[A-Za-z0-9]*$/', $session_id))
	{
		return;
	}
	
	//
	// Delete existing session
	//
	$sql = "DELETE FROM " . SESSIONS_TABLE . " 
		WHERE session_id = '$session_id' 
			AND session_user_id = $user_id";
	if ( !$db->sql_query($sql) )
	{
		message_die(CRITICAL_ERROR, 'Error removing user session', '', __LINE__, __FILE__, $sql);
	}

	setcookie($cookiename . '_data', '', $current_time - 31536000, $cookiepath, $cookiedomain, $cookiesecure);
	setcookie($cookiename . '_sid', '', $current_time - 31536000, $cookiepath, $cookiedomain, $cookiesecure);

	return true;
}

//
// Append $SID to a url. Borrowed from phplib and modified. This is an
// extra routine utilised by the session code above and acts as a wrapper
// around every single URL and form action. If you replace the session
// code you must include this routine, even if it's empty.
//
function append_sid($url, $non_html_amp = false)
{
// Begin PNphpBB2 Module
//	global $SID;
//
//	if ( !empty($SID) && !preg_match('#sid=#', $url) )
//	{
//		$url .= ( ( strpos($url, '?') != false ) ?  ( ( $non_html_amp ) ? '&' : '&amp;' ) : '?' ) . $SID;
//	}
	
  global $SID, $phpEx, $ModName, $HTTP_SERVER_VARS;

	$url = str_replace("." . $phpEx, "", $url);   // Do away with extensions (Should do this before we get here)
	$url = str_replace("?", "&", $url);     // Changes initial ? for &
	$url = str_replace("&amp;", '&', $url); // Replace all &amp;'s with &

  $module_url = "index." . $phpEx . "?name=" . $ModName . "&file=";
  // $module_url = "modules." . $phpEx . "?op=modload&name=" . $ModName . "&file=";
	
	list($admin_file, $admin_module) = explode("_", $url);
	if ($admin_file == "admin")
  {		
	  $url = $module_url . $admin_file . "&pnadmin=" . $url;
	}
	else
	{
 	  $url = $module_url . $url;
	}

  if ( !empty($SID) && !eregi('sid=', $url) && !strstr($HTTP_SERVER_VARS['HTTP_USER_AGENT'] ,'Googlebot') && !strstr($HTTP_SERVER_VARS['HTTP_USER_AGENT'] ,'slurp@inktomi.com;')) 
	{
		$url .= ( ( strpos($url, '?') != false ) ? '&' : '?' ) . $SID;
	}
  
  $url = ( $non_html_amp ) ? $url : str_replace("&", "&amp;", $url);
// End PNphpBB2 Module
  return $url;
}

?>
